'==========================================================================
'
' Author......: Raffaele Chiatto
'
' WebSite.....: http://www.raffaelechiatto.com
'
' E-Mail......: raffaele.chiatto@gmail.com
'
'==========================================================================


Option Explicit

Const path1 = "D:\Sorgente"		' Cartella Sorgente
Const path2 = "D:\Raffaele"		' 
Const path3 = "D:\Destinazione\"	' Cartella Target

Dim Text, Title,  destination 
Dim fso                     ' Object variable
Dim flag

Text = "Backup folder " & path1 & "?"
Title = "WSH sample - by G. Born"

If (MsgBox(Text, vbYesNo + vbQuestion, Title) = vbNo) Then
    WScript.Quit         ' Cancel selected.
End If

' Create the name of the destination folder. Because
' localized versions of Windows can use illegal filename
' characters (such as \ and :) in the date format,
' create the name manually from the date.
destination = path2 & Day(Date) & "-" & Month(Date) & _
              "-" & Year(Date)

' Create FileSystemObject object to access the file system.
Set fso = CreateObject("Scripting.FileSystemObject")

' Test whether the source folder exists.
If (Not fso.FolderExists(path1)) Then
    Text = "Folder " & path1 & " not found!"
    MsgBox Text, vbOKOnly + vbInformation, Title
    WScript.Quit
End If

' Check whether there are files in the source folder. If
' not, the copy operation causes a run-time error.
' We don't need to create the destination folder if the
' source is empty.
If FolderEmpty(path1) Then 
    Text = "Nothing to save in " & path1
    MsgBox Text, vbOKOnly + vbInformation, Title
    WScript.Quit
End If

' Check whether the target folder exists.
If (Not fso.FolderExists(destination)) Then
    ' Does parent folder exist?
    If (Not fso.FolderExists(path3)) Then _
        fso.CreateFolder(path3)    ' First step

    fso.CreateFolder(destination)  ' Create backup folder.
End If

' Copy files from source to target.
fso.CopyFile path1 & "\*.*", destination

Text = "Folder " & path1 & " is backed up to " & destination 
MsgBox Text, vbOKOnly + vbInformation, Title

' Check for an empty folder.
Function FolderEmpty (name)
    Dim fso, oFolder, oFiles         ' Object variables
    Dim i, flag

    Set fso = CreateObject("Scripting.FileSystemObject")
    Set oFolder = fso.GetFolder(path1)  ' Get folder.
    Set oFiles = oFolder.Files          ' Get Files collection.
    flag = True                         ' No files
    For Each i In oFiles                ' A file is found if
        flag = False                    ' the loop is processed.
    Next
    FolderEmpty = flag                  ' Return result.
End Function

'*** End

